//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_PIXELBUFFER_H
#define CANDERA_PIXELBUFFER_H

#include <Candera/Engine3D/Core/DeviceObject.h>

namespace Candera {

/** @addtogroup Core3D
 *  @{
 */

class PixelBuffer : public DeviceObject
{
    FEATSTD_TYPEDEF_BASE(DeviceObject);

public:
    /**
     *  Constructor.
     */
    PixelBuffer(SizeType size, bool isPixelPack);

    /**
     *  Destructor.
     */
    virtual ~PixelBuffer() override;

    /**
     *  Get the size of the pixel buffer.
     *  @return  The size of the pixel buffer.
     */
    SizeType GetSize() const { return m_size; }

    /**
     *  Query if the pixel buffer is a pixel pack buffer.
     *  @return  True if the pixel buffer is a pixel pack buffer.
     *           False if the pixel buffer is a pixel unpack buffer.
     */
    bool IsPixelPack() const { return m_isPixelPack; }

protected:

    /**
     *  Upload the buffer object to VRAM
     *  @param loadingHint  See DeviceObject::LoadingHint for details.
     *  @return  True, if uploading the buffer object to VRAM succeeded. False, otherwise.
     */
    virtual bool UploadInternal(LoadingHint loadingHint) override;

    /**
     *  Unload the buffer object from VRAM
     *  @param loadingHint  See DeviceObject::LoadingHint for details.
     *  @return  True, if unloading the buffer object from VRAM succeeded. False, otherwise.
     */
    virtual bool UnloadInternal(LoadingHint loadingHint) override;

    /**
     *  Empty implementation of DisposeInternal.
     */
    virtual void DisposeInternal() override {};

    /**
     *  Copy constructor
     */
    PixelBuffer(const PixelBuffer& rhs);

private:
    friend class Renderer;
    Handle m_deviceHandle[CANDERA_MAX_CONTEXT_COUNT];
    SizeType m_size;
    bool m_isPixelPack;
};

}

#endif
