//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_LodCriterion_h
#define Candera_LodCriterion_h

#include <Candera/Environment.h>
#include <Candera/System/Rtti/Rtti.h>

namespace Candera {

/** @addtogroup Core3D
 *  @{
 */
 
//Forward declaration
class LodNode;

/**
 *  @brief The abstract class LodCriterion defines an interface that returns an criterion value in order to calculate the appropriate level-of-detail (LOD) level 
 *         of a LodNode. The LodCriterion is utilized by LodStrategy. A typical LodCrition is for instance the DistanceToCameraLodCriterion, which calculates the
 *         distance to Camera as an criterion value to calculate the appropriate LOD level.
 */
class LodCriterion
{
    public:

        FEATSTD_RTTI_DECLARATION();

        /**
         *  Constructor
         */
        LodCriterion() {}

        /**
         *  Destructor
         */
        virtual ~LodCriterion() {}

        /**
         *  Retrieves a criterion value for further LOD level calculation.
         *  @param  lodNode The LOD node on which the criterion shall be calculated.
         *  @return The calculated LOD criterion.
         */
        virtual Float GetCriterionValue(const LodNode& lodNode) const = 0;
};
 
/** @} */ // end of Core3D
 
}

#endif // Candera_LodCriterion_h
