//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_GLYPHATLAS3DGLYPHCACHEACCESS_H
#define CANDERA_GLYPHATLAS3DGLYPHCACHEACCESS_H

#include <Candera/EngineBase/Common/GlyphAtlasGlyphCacheAccess.h>

namespace Candera {

class GlyphAtlas3DGlyphCacheAccess : public GlyphAtlasGlyphCacheAccess
{
public:
    FEATSTD_LINT_NEXT_EXPRESSION(1511, "This is hiding a static method - and therefore intended behavior as both can have a singleton!")
    static GlyphAtlas3DGlyphCacheAccess& GetInstance();

    using GlyphAtlasGlyphCacheAccess::Create;

    // overrides TextRendering::GlyphCacheAccess::Create
    virtual UInt8* Create(const TextRendering::GlyphBitmap& bitmap, UInt8* cacheItem);

    // overrides TextRendering::GlyphCacheAccess::CheckCacheItem
    virtual bool CheckCacheItem(TextRendering::PixelBuffer buffer) override;

private:
    virtual ~GlyphAtlas3DGlyphCacheAccess() {};
    friend struct FeatStd::MemoryManagement::Internal::Destructor<GlyphAtlas3DGlyphCacheAccess>;
    friend class GlyphAtlas3DGlyphCacheAccessArray;
    FEATSTD_MAKE_CLASS_STATIC(GlyphAtlas3DGlyphCacheAccess);
    FEATSTD_MAKE_CLASS_UNCOPYABLE(GlyphAtlas3DGlyphCacheAccess);
};

}

#endif
