//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlyphAtlas3DGlyphCacheAccess.h"

#include <Candera/Engine3D/Core/GlyphAtlas3D.h>
#include <CanderaPlatform/Device/Common/Base/ContextResourcePool.h>

namespace Candera {

class GlyphAtlas3DGlyphCacheAccessArray
{
public:
    GlyphAtlas3DGlyphCacheAccessArray()
    {
        for (SizeType i = 0; i < CANDERA_MAX_CONTEXT_COUNT; ++i) {
            m_glyphAtlas3DGlyphCacheAccess[i] = CANDERA_NEW(GlyphAtlas3DGlyphCacheAccess);
        }
    }

    ~GlyphAtlas3DGlyphCacheAccessArray()
    {
        for (SizeType i = 0; i < CANDERA_MAX_CONTEXT_COUNT; ++i) {
            CANDERA_DELETE(m_glyphAtlas3DGlyphCacheAccess[i]);
            m_glyphAtlas3DGlyphCacheAccess[i] = 0;
        }
    }

    GlyphAtlas3DGlyphCacheAccess& operator[](SizeType index) const
    {
        FEATSTD_DEBUG_ASSERT(index < CANDERA_MAX_CONTEXT_COUNT);
        return *(m_glyphAtlas3DGlyphCacheAccess[index]);
    }

private:
    GlyphAtlas3DGlyphCacheAccess* m_glyphAtlas3DGlyphCacheAccess[CANDERA_MAX_CONTEXT_COUNT];
};

GlyphAtlas3DGlyphCacheAccess& GlyphAtlas3DGlyphCacheAccess::GetInstance()
{
    FEATSTD_SYNCED_STATIC_OBJECT(GlyphAtlas3DGlyphCacheAccessArray, s_instance);
    return s_instance[ContextResourcePool::GetActive().GetIndex()];
}

GlyphAtlas3DGlyphCacheAccess::GlyphAtlas3DGlyphCacheAccess()
{
}

UInt8* GlyphAtlas3DGlyphCacheAccess::Create(const TextRendering::GlyphBitmap& bitmap, UInt8* cacheItem)
{
    return CreateCacheItem<GlyphAtlas3D>(bitmap, cacheItem);
}

bool GlyphAtlas3DGlyphCacheAccess::CheckCacheItem(TextRendering::PixelBuffer buffer)
{
    return CheckCacheItemT<GlyphAtlas3D>(buffer);
}

}
