//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Frustum.h"
#include <Candera/Engine3D/Core/Mesh.h>
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera {
    using namespace Diagnostics;

    // enable if logging is used here
    // FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

Frustum::Frustum()
{
}

Frustum::~Frustum()
{

}

bool Frustum::IsPointInFrustum(const Vector3& point) const
{
    UInt8 planeIdx = 0;
    while ((planeIdx < NumberOfPlanes) && m_planes[planeIdx].IsInFront(point)) {
        planeIdx++;
    }

    return planeIdx == NumberOfPlanes;
}

bool Frustum::IsSphereInFrustum(const Vector3& center, Float radius) const
{
    UInt8 planeIdx = 0;
    while ((planeIdx < NumberOfPlanes) && (m_planes[planeIdx].GetDistanceTo(center) > -radius)) {
        planeIdx++;
    }

    return planeIdx == NumberOfPlanes;
}

bool Frustum::IsPolygonInFrustum(UInt noOfPoints, const Vector3* pointList) const
{
    UInt8 planeIdx = 0;
    UInt ptIdx = 0;
    while (planeIdx < NumberOfPlanes) {
        while ((ptIdx < noOfPoints) && m_planes[planeIdx].IsInFront(pointList[ptIdx])) {
            ptIdx++;
        }
        if (ptIdx != noOfPoints) {
            break;
        }
        planeIdx++;
    }

    return (planeIdx == NumberOfPlanes) && (ptIdx == noOfPoints);
}

bool Frustum::IsMeshInFrustum(const Mesh& mesh) const
{
    return IsSphereInFrustum(mesh.GetWorldCenter(), mesh.GetWorldRadius());
}

Float Frustum::GetDistanceToNearPlane(const Vector3& point) const
{
    return m_planes[NearPlane].GetDistanceTo(point);
}
} // namespace Candera

