//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DistanceToCameraLodCriterion.h"
#include <Candera/Engine3D/Core/LodNode.h>
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/System/Mathematics/Vector3.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>

namespace Candera {

    FEATSTD_RTTI_DEFINITION(DistanceToCameraLodCriterion, LodCriterion)

Float DistanceToCameraLodCriterion::GetCriterionValue(const LodNode& lodNode) const
{
    const Camera* camera = RenderDevice::GetActiveCamera();
    if (camera == 0) {        
        //TODO TRACE.
        return -1.0F;        
    }
    
    // Calculate distance from camera this LodNode's center in world space.
    const Vector3 cameraPos = camera->GetWorldPosition();
    return cameraPos.GetDistanceTo(lodNode.GetWorldCenter());  
}

}

