//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DiscreteLodRenderStrategy.h"
#include <Candera/Engine3D/Core/LodCriterion.h>
#include <Candera/Engine3D/Core/LodNode.h>

namespace Candera {

    FEATSTD_RTTI_DEFINITION(DiscreteLodRenderStrategy, LodRenderStrategy)

void DiscreteLodRenderStrategy::ActivateLodLevel(LodNode& lodNode, UInt lodIndex) const
{   
    CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1764, lodNode, CANDERA_LINT_REASON_NONCONST)
    
    for(Int i= 0; i < static_cast<Int>(lodNode.GetLodLevelCount()); i ++) {        
        Node* node= lodNode.GetLodLevel(static_cast<UInt>(i)).node;
        if (node != 0) {
            node->SetRenderingEnabled(static_cast<UInt>(i) == lodIndex);
        }
    }
}


void DiscreteLodRenderStrategy::Update(LodNode& lodNode)
{
    if (GetLodCriterion() != 0) {
        Float criterionValue = GetLodCriterion()->GetCriterionValue(lodNode);
        Int lodIndex = lodNode.GetLodIndex(criterionValue);
        if (lodIndex >= 0) {            
            ActivateLodLevel(lodNode, static_cast<UInt>(lodIndex));
        }
    }            
}

}

