//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ClearMode.h"
#include <FeatStd/Util/Hash.h>

namespace Candera {

ClearMode::ClearMode() :
    m_isColorClearEnabled(false),
    m_isDepthClearEnabled(false),
    m_isStencilClearEnabled(false),
    m_isColorWriteRedEnabled(true),
    m_isColorWriteGreenEnabled(true),
    m_isColorWriteBlueEnabled(true),
    m_isColorWriteAlphaEnabled(true),
    m_isSkyBoxEnabled(false),
    m_stencilClearValue(0),
    m_stencilWriteMask(~(static_cast<UInt32>(0U))),
    m_clearDepth(1.0F),
    m_skyBox(0)
{
}

void ClearMode::SetColorWriteEnabled(bool enableRed, bool enableGreen, bool enableBlue, bool enableAlpha)
{
    SetColorWriteRedEnabled(enableRed);
    SetColorWriteGreenEnabled(enableGreen);
    SetColorWriteBlueEnabled(enableBlue);
    SetColorWriteAlphaEnabled(enableAlpha);
}

void ClearMode::UpdateHash(UInt32& hash) const
{
    using namespace FeatStd;

    // Use a bitmask for all the boolean values
    UInt8 bmask = 0x00;
    bmask = m_isColorClearEnabled ? (bmask | 0x1) : bmask;
    bmask = m_isDepthClearEnabled ? (bmask | 0x2) : bmask;
    bmask = m_isStencilClearEnabled ? (bmask | 0x4) : bmask;
    bmask = m_isColorWriteRedEnabled ? (bmask | 0x8) : bmask;
    bmask = m_isColorWriteGreenEnabled ? (bmask | 0x10) : bmask;
    bmask = m_isColorWriteBlueEnabled ? (bmask | 0x20) : bmask;
    bmask = m_isColorWriteAlphaEnabled ? (bmask | 0x40) : bmask;
    bmask = m_isSkyBoxEnabled ? (bmask | 0x80) : bmask;

    static_cast<void>(Hash::UpdateBinBufferHash(reinterpret_cast<const UInt8*>(&bmask),
        reinterpret_cast<const UInt8*>(&bmask) + sizeof(bmask),
        hash));

    if (m_isStencilClearEnabled)
    {
        static_cast<void>(Hash::UpdateBinBufferHash(reinterpret_cast<const UInt8*>(&m_stencilClearValue),
            reinterpret_cast<const UInt8*>(&m_stencilClearValue) + sizeof(m_stencilClearValue),
            hash));
        static_cast<void>(Hash::UpdateBinBufferHash(reinterpret_cast<const UInt8*>(&m_stencilWriteMask),
            reinterpret_cast<const UInt8*>(&m_stencilWriteMask) + sizeof(m_stencilWriteMask),
            hash));
    }

    if (m_isSkyBoxEnabled && (m_skyBox != 0))
    {
        static_cast<void>(Hash::UpdateBinBufferHash(reinterpret_cast<const UInt8*>(m_skyBox.GetPointerToSharedInstance()),
            reinterpret_cast<const UInt8*>(m_skyBox.GetPointerToSharedInstance()) + sizeof(m_skyBox.GetSharedInstance()),
            hash));
    }
}
} // namespace Candera
