//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CameraLookAtNodeController.h"
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/Engine3D/Core/Node.h>

namespace Candera {

    FEATSTD_RTTI_DEFINITION(CameraLookAtNodeController, ControllerComponent)

void CameraLookAtNodeController::LateUpdate(ControllerEntity* entity)
{
    Camera* camera = Dynamic_Cast<Camera*>(entity);
    FEATSTD_DEBUG_ASSERT(0 != camera);
    Node* lookAtNode = camera->GetLookAtNode();
    if (0 != lookAtNode) {
        Vector3 actualLookAtNodePosition = lookAtNode->GetWorldPosition();
        static_cast<void>(camera->LookAtWorldPoint(actualLookAtNodePosition));
    }
}

}
