//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/Engine3D/Core/BenchmarkCameraRenderStrategy.h>
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera {
    using namespace Diagnostics;

FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

FEATSTD_RTTI_DEFINITION(BenchmarkCameraRenderStrategy, CameraRenderStrategy)

BenchmarkCameraRenderStrategy::BenchmarkCameraRenderStrategy() :
    Base(),
    m_threshold(0.0F),
    m_benchmarkSum(0.0F),
    m_actionOnThreshold(PauseRenderPass)
{
}

CameraRenderStrategy::RenderPassAction BenchmarkCameraRenderStrategy::GetRenderPassAction(const Node* nextNode)
{
    m_benchmarkSum += nextNode->GetRenderBenchmark();
    RenderPassAction renderPassAction = (m_benchmarkSum > m_threshold) ? m_actionOnThreshold : ProceedRenderPass;

    FEATSTD_LOG_INFO("GetRenderPassAction: %s, benchmark: %0.1F, sum: %0.1F, threshold: %0.1F",
        (nextNode->GetName() != 0) ? nextNode->GetName() : "<Node>",  nextNode->GetRenderBenchmark(), m_benchmarkSum, m_threshold);

    return renderPassAction;
}

void BenchmarkCameraRenderStrategy::OnRenderPassBegins()
{
    FEATSTD_LOG_INFO("BenchmarkCameraRenderStrategy::OnRenderPassBegins");
    m_benchmarkSum = 0.0F;
}

void BenchmarkCameraRenderStrategy::OnRenderPassResumes()
{
    FEATSTD_LOG_INFO("BenchmarkCameraRenderStrategy::OnRenderPassResumes");
    m_benchmarkSum = 0.0F;
}
} // namespace Candera

