//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepReflectionCameraCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/ReflectionCamera.h>
#include <Candera/Engine3D/Cloning/TreeMatch.h>

namespace Candera {

void DeepReflectionCameraCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    m_cameraCloneStrategy.Execute(
        CameraCloneStrategy::Pair(
            current.source,
            current.clone),
        root);

    Node* sourceCameraClone = TreeMatch::Find(
            current.source->GetSourceCamera(),
            root.source,
            root.clone);
    current.clone->SetSourceCamera(Dynamic_Cast<Camera*>(sourceCameraClone));
}


} // namespace Candera
