//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepNodeCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/Engine3D/Core/CompositeGroup.h>
#include <Candera/Engine3D/Core/LodNode.h>
#include <Candera/Engine3D/Core/ReflectionCamera.h>
#include <Candera/Engine3D/Core/Scene.h>
#include <Candera/Engine3D/Core/StereoCamera.h>

namespace Candera {

void DeepNodeCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    current.clone->SetAppearance(
        m_appearance.Clone(
            current.source->GetAppearance(), 
            root).sharedObject);

    if (current.source->GetDynamicTypeId() == Camera::GetTypeId()) {
         m_camera.Execute(
            CameraCloneStrategy::Pair(
                Dynamic_Cast<const Camera*>(current.source),
                Dynamic_Cast<Camera*>(current.clone)),
            root);
    }
    else if (current.source->GetDynamicTypeId() == CompositeGroup::GetTypeId()) {
         m_compositeGroup.Execute(
            CompositeGroupCloneStrategy::Pair(
                Dynamic_Cast<const CompositeGroup*>(current.source),
                Dynamic_Cast<CompositeGroup*>(current.clone)),
            root);
    }
    else if (current.source->GetDynamicTypeId() == LodNode::GetTypeId()) {
         m_lodNode.Execute(
            LodNodeCloneStrategy::Pair(
                Dynamic_Cast<const LodNode*>(current.source),
                Dynamic_Cast<LodNode*>(current.clone)),
            root);
    }
    else if (current.source->GetDynamicTypeId() == ReflectionCamera::GetTypeId()) {
         m_reflectionCamera.Execute(
            ReflectionCameraCloneStrategy::Pair(
                Dynamic_Cast<const ReflectionCamera*>(current.source),
                Dynamic_Cast<ReflectionCamera*>(current.clone)),
            root);
    }
    else if (current.source->GetDynamicTypeId() == Scene::GetTypeId()) {
         m_scene.Execute(
            SceneCloneStrategy::Pair(
                Dynamic_Cast<const Scene*>(current.source),
                Dynamic_Cast<Scene*>(current.clone)),
            root);
    }
    else if (current.source->GetDynamicTypeId() == StereoCamera::GetTypeId()) {
         m_stereoCamera.Execute(
            StereoCameraCloneStrategy::Pair(
                Dynamic_Cast<const StereoCamera*>(current.source),
                Dynamic_Cast<StereoCamera*>(current.clone)),
            root);
    }
    else {
        // No special action for unsupported nodes.
    }
}

void DeepNodeCloneStrategy::Clear()
{
    m_appearance.Clear();
    m_camera.Clear();
    m_compositeGroup.Clear();
    m_lodNode.Clear();
    m_reflectionCamera.Clear();
    m_scene.Clear();
    m_stereoCamera.Clear();
}


} // namespace Candera
