//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepLodNodeCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/LodNode.h>
#include <Candera/Engine3D/Cloning/TreeMatch.h>

namespace Candera {

void DeepLodNodeCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    SizeType signedLevelCount = current.source->GetLodLevelCount();
    SizeType levelCount = signedLevelCount;
    for (SizeType level = 0; level < levelCount; level++) {
        const LodNode::LodLevel& sourceLevel = current.source->GetLodLevel(level);
        Node* levelNodeClone = TreeMatch::Find(
                sourceLevel.node,
                root.source,
                root.clone);
        static_cast<void>(current.clone->SetLodLevel(
            level,
            levelNodeClone,
            sourceLevel.lowerBound,
            sourceLevel.upperBound));
    }
}


} // namespace Candera
