//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_COMPOSITE_GROUP_CLONE_STRATEGY_H)
#define CANDERA_DEEP_COMPOSITE_GROUP_CLONE_STRATEGY_H

#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

/**
 * @brief This is the default clone strategy for deep cloning composite groups.
 * See DeepNodeCloneStrategy for rules.
 */
class DeepCompositeGroupCloneStrategy : public CompositeGroupCloneStrategy{
public:
    // Implement pure function from CompositeGroupCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;

    // Implement pure function from CompositeGroupCloneStrategy.
    virtual void Clear() override {}
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_COMPOSITE_GROUP_CLONE_STRATEGY_H
