//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepCompositeGroupCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/CompositeGroup.h>
#include <Candera/Engine3D/Cloning/TreeMatch.h>

namespace Candera {

void DeepCompositeGroupCloneStrategy::Execute(const Pair& current, const RootPair& /*root*/)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    CompositeGroup::AnchorPointIterator iterator = current.source->GetAnchorPointIterator();
    for (; iterator.IsValid(); ++iterator) {
        CompositeGroup::AnchorPoint anchorPoint = *iterator;
        // Anchors should be children of the current node.
        Node* anchorPointCloneNode = TreeMatch::Find(
                anchorPoint.m_node,
                current.source,
                current.clone);
        static_cast<void>(Internal::CompositeGroupFunctions::DefineAnchorPoint(
            *current.clone,
            anchorPoint.m_id,
            anchorPoint.m_name,
            anchorPointCloneNode));
    }
}


} // namespace Candera
