//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepCameraCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/Camera.h>

namespace Candera {

void DeepCameraCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    current.clone->SetProjection(
        m_projection.Clone(
            current.source->GetProjection(), 
            root).sharedObject);
}

} // namespace Candera
