//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepAppearanceCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/MultiPassAppearance.h>

namespace Candera {
    using namespace Diagnostics;
    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

DeepAppearanceCloneStrategy::Result DeepAppearanceCloneStrategy::Clone(
    const SharedPointer& source,
    const NodeCloneStrategy::Pair& root)
{
    Result clone = m_apperanceMap.Clone(source, root);

    if (clone.isNew && (clone.sharedObject != 0)) {
        clone.sharedObject->SetRenderMode(
            m_renderMode.Clone(
                clone.sharedObject->GetRenderMode(),
                root).sharedObject);

        clone.sharedObject->SetMaterial(
            m_material.Clone(
                clone.sharedObject->GetMaterial(),
                root).sharedObject);

        clone.sharedObject->SetShaderParamSetter(
            m_shaderParamSetter.Clone(
                clone.sharedObject->GetShaderParamSetter(),
                root).sharedObject);
        bool textureResult = true; 
        for (UInt i = 0; i < CANDERA_MAX_TEXTURE_UNIT_COUNT; i++) {
            if (!clone.sharedObject->SetTexture(
                    m_texture.Clone(clone.sharedObject->GetTexture(i), root).sharedObject, i)) {
                    textureResult = false;
            }
        }
        if (!textureResult) {
            FEATSTD_LOG_WARN("Setting Texture for cloned object failed.");
        }

        MultiPassAppearance::SharedPointer sourceMultiPassApperance = 
            Dynamic_Cast<MultiPassAppearance::SharedPointer>(source);
        MultiPassAppearance::SharedPointer destinationMultiPassApperance = 
            Dynamic_Cast<MultiPassAppearance::SharedPointer>(clone.sharedObject);
        bool isMultiPass = (sourceMultiPassApperance != 0) && 
            (destinationMultiPassApperance != 0);
        if (isMultiPass) {
            Result nextPass =
                Clone(sourceMultiPassApperance->GetNextPass(), root);
            destinationMultiPassApperance->SetNextPass(
                Dynamic_Cast<MultiPassAppearance::SharedPointer>(nextPass.sharedObject));
        }
    }

    return clone;
}

void DeepAppearanceCloneStrategy::Clear()
{
    m_apperanceMap.Clear();
    m_material.Clear();
    m_renderMode.Clear();
    m_texture.Clear();
    m_shaderParamSetter.Clear();
}


} // namespace Candera
