//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanvasTextBatch.h"

#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/System/Mathematics/Line.h>

namespace Candera {
namespace Internal {

FEATSTD_RTTI_DEFINITION(CanvasTextBatch, Mesh)

CanvasTextBatch::CanvasTextBatch()
{
}

CanvasTextBatch::~CanvasTextBatch()
{
    static_cast<void>(Mesh::Unload());
}

CanvasTextBatch* CanvasTextBatch::Create()
{
    return FEATSTD_NEW(CanvasTextBatch);
}

bool CanvasTextBatch::IsLineIntersectingGeometry(const Line& line, Float& distance) const
{
    FEATSTD_UNUSED2(line, distance);
    // CanvasTextBatch is an internally used Mesh representing renderable CanvasTexts.
    // Since individual CanvasTexts are intersectable, this must not be intersectable.
    return false;
}

bool CanvasTextBatch::ComputeBoundingBoxImpl(Vector3& minBounds, Vector3& maxBounds) const
{
    const VertexBuffer* vertexBuffer = GetVertexBuffer().GetPointerToSharedInstance();
    if (0 != vertexBuffer) {
        const VertexGeometry* vertexGeometry = vertexBuffer->GetVertexGeometry();
        if (0 != vertexGeometry) {
            if (vertexGeometry->GetVertexCount() > 0) {
                // If VertexGeometry exists, it has been created by Canvas (which is the sole user of this internal class).
                // Canvas has also computed the bounding box while creating the VertexGeometry, so just need to return it.
                GetBoundingBox(minBounds, maxBounds);
                return true;
            }
        }
    }

    return false;
}

bool CanvasTextBatch::IsPickIntersectingGeometryInternal(const Camera& camera, Int x, Int y, Float& distance /*out*/) const
{
    FEATSTD_UNUSED4(camera, x, y, distance);
    // CanvasTextBatch is an internally used Mesh representing renderable CanvasTexts.
    // Since individual CanvasTexts are pickable, this must not be pickable.
    return false;
}

}
}
