//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanvasRenderable.h"

#include <Candera/Engine3D/Canvas/Canvas.h>

namespace Candera {

    FEATSTD_SUPPRESS_MSC_WARNING_BEGIN(4355,"Only reference is set, but not used inside constructor.")
    CanvasRenderable::CanvasRenderable() :
        Base(),
        m_vertexRectangle(0.0F, 0.0F, -1.0F, -1.0F),
        m_targetTexture(0),
        m_canvasTransformable(*this, *this)
    {

    }
    FEATSTD_SUPPRESS_MSC_WARNING_END()

    FEATSTD_SUPPRESS_MSC_WARNING_BEGIN(4355,"Only reference is set, but not used inside constructor.")
    CanvasRenderable::CanvasRenderable(const Candera::CanvasRenderable &other) :
        Base(other),
        m_vertexRectangle(other.m_vertexRectangle),
        m_targetTexture(other.m_targetTexture),
        m_canvasTransformable(*this, *this)
    {
        if (other.m_canvasTransformable.IsBoundingRectangleSet()) {
            m_canvasTransformable.SetBoundingRectangle(other.m_canvasTransformable.GetBoundingRectangle());
        }
    }
    FEATSTD_SUPPRESS_MSC_WARNING_END()

    CanvasTransformable& CanvasRenderable::GetCanvasTransformable()
    {
        return m_canvasTransformable;
    }

    void CanvasRenderable::OnCompositeTransformChanged()
    {
        Base::OnCompositeTransformChanged();
        Canvas* parentalCanvas = m_canvasTransformable.GetParentCanvas();
        if (0 != parentalCanvas) {
            parentalCanvas->SetChanged();
        }
    }

#if defined(CANDERA_LAYOUT_ENABLED)
    const Candera::Vector3 CanvasRenderable::GetLayoutStartPosition() const
    {
        return m_canvasTransformable.GetLayoutStartPosition();
    }
#endif


    FEATSTD_RTTI_DEFINITION(CanvasRenderable, Base)

}
