//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_V3PropertySetterUtil_H)
#define CANDERA_V3PropertySetterUtil_H

#include <Candera/Environment.h>
#include <Candera/System/Mathematics/Vector3.h>

namespace Candera {
    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

    typedef Vector3 (*V3Getter)(const Node&);
    typedef void (*V3Setter)(Node&, const Vector3&);

    typedef void (*AxisSelector)(const Float* value, Vector3& destV3);
    inline void X_AxisSelector(const Float* value, Vector3& destV3)
    {
        destV3.SetX(value[0]);
    }
    inline void Y_AxisSelector(const Float* value, Vector3& destV3)
    {
        destV3.SetY(value[0]);
    }
    inline void Z_AxisSelector(const Float* value, Vector3& destV3)
    {
        destV3.SetZ(value[0]);
    }
    inline  void XYZ_AxisSelector(const Float* value, Vector3& destV3)
    {
        destV3.SetX(value[0]);
        destV3.SetY(value[1]);
        destV3.SetZ(value[2]);
    }

    template<V3Getter v3g, V3Setter v3s, AxisSelector axisSel>
    void SetVector3Property(Node* const n, const Float* value)
    {
        if (n == 0) {
            return;
        }

        if (value == 0) {
            return;
        }

        Vector3 v3 = v3g(*n);
        axisSel(value, v3);
        v3s(*n, v3);
    }
/** @} */ // end of AnimationPropertySetters3D
    } // namespace Animation

} // namespace Candera

#endif
