//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "UniformPropertySetter.h"

namespace Candera {
    namespace Animation {

    FEATSTD_RTTI_DEFINITION(UniformPropertySetter, AnimationPropertySetter)

UniformPropertySetter::UniformPropertySetter() :
    Base(),
    m_index(0),
    m_uniformName(0),
    m_shaderParamSetter(0)
{
}

UniformPropertySetter::~UniformPropertySetter()
{
    m_uniformName = 0;
}

void UniformPropertySetter::SetFloat(const Float* value, Int32 size)
{
    if (!IsValid()) {
        return;
    }

    Float* data = 0;
    bool success = m_shaderParamSetter->GetUniformData(m_uniformName, data);

    if (success && (data != 0)) {
        UInt32 blockSize = static_cast<UInt32>(size) * sizeof(Float);
        MemoryPlatform::Copy(data + static_cast<UInt32>(m_index * size), value, blockSize);
    }
}

void UniformPropertySetter::SetInt(const Float* value, Int32 size)
{
    if (!IsValid()) {
        return;
    }

    Int32* data = 0;
    bool success = m_shaderParamSetter->GetUniformData(m_uniformName, data);

    if (success && (data != 0)) {
        for (Int32 i = 0; i < size; i++) {
            data[i + (m_index * size)] = static_cast<Int32>(value[i]);
        }
    }
}

void UniformPropertySetter::SetBool(const Float* value, Int32 size)
{
    if (!IsValid()) {
        return;
    }

    Int32* data = 0;
    bool success = m_shaderParamSetter->GetUniformData(m_uniformName, data);

    if (success && (data != 0)) {
        for (Int32 i = 0; i < size; i++) {
            data[i + (m_index * size)] = (value[i] < 0.5F) ? 0 : 1;
        }
    }
}

bool UniformPropertySetter::IsValid()
{
    if ((m_shaderParamSetter == 0) || (m_uniformName == 0)) {
        return false;
    }

    Int32 count = 0;
    bool success = m_shaderParamSetter->GetUniformCount(m_uniformName, count);
    if ((!success) || (m_index < 0) || (m_index >= count)) {
        return false;
    }

    return true;
}

    }
}
