//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TranslateNodeRelativePropertySetter_H)
#define CANDERA_TranslateNodeRelativePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/NodeRelativePropertySetter.h>
#include <Candera/System/Mathematics/Vector3.h>

namespace Candera {

    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /**
         * @brief A RelativePropertySetter that sets the translation, XYZ of a Node.
         *
         * The absolute translation will be calculated from the initial value by adding the relative one.
         */
        class TranslateNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(TranslateNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                TranslateNodeRelativePropertySetter():m_position(Vector3(0.0F, 0.0F, 0.0F)) {}

                /**
                 *  Destructor
                 */
                virtual ~TranslateNodeRelativePropertySetter() override {}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the translation, XYZ of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Vector3 m_position;
        };

        /**
         * @brief A RelativePropertySetter that sets the translation, X of a Node.
         *
         * The absolute translation will be calculated from the initial value by adding the relative one.
         */
        class TranslateXNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(TranslateXNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                TranslateXNodeRelativePropertySetter():m_positionX(0.0F) {}

                /**
                 *  Destructor
                 */
                virtual ~TranslateXNodeRelativePropertySetter() override {}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the translation, X of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Float m_positionX;
        };

        /**
         * @brief A RelativePropertySetter that sets the translation, Y of a Node.
         *
         * The absolute translation will be calculated from the initial value by adding the relative one.
         */
        class TranslateYNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(TranslateYNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                TranslateYNodeRelativePropertySetter():m_positionY(0.0F) {}

                /**
                 *  Destructor
                 */
                virtual ~TranslateYNodeRelativePropertySetter() override {}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the translation, Y of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Float m_positionY;
        };

        /**
         * @brief A RelativePropertySetter that sets the translation, Z of a Node.
         *
         * The absolute translation will be calculated from the initial value by adding the relative one.
         */
        class TranslateZNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(TranslateZNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                TranslateZNodeRelativePropertySetter():m_positionZ(0.0F) {}

                /**
                 *  Destructor
                 */
                virtual ~TranslateZNodeRelativePropertySetter() override{}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the translation, Z of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Float m_positionZ;
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
