//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RotateNodeRelativePropertySetter_H)
#define CANDERA_RotateNodeRelativePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/NodeRelativePropertySetter.h>
#include <Candera/System/Mathematics/Vector3.h>

namespace Candera {

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

        /**
         * @brief A RelativePropertySetter that sets the rotation, XYZ of a Node.
         *
         * The absolute rotation will be calculated from the initial value by adding the relative one.
         */
        class RotateNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

        public:
            FEATSTD_RTTI_DECLARATION();

            FEATSTD_TYPEDEF_SHARED_POINTER(RotateNodeRelativePropertySetter);
            
            /**
             *  Constructor
             */
            RotateNodeRelativePropertySetter():m_rotation(Vector3(0.0F, 0.0F, 0.0F)) {}

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
            /**
             *  Destructor
             */
            virtual ~RotateNodeRelativePropertySetter() override {}

            // override (AnimationPropertySetter)
            /**
             *  A RelativePropertySetter that sets the rotation, XYZ of a Node.
             *  @param  value   The relative value that is assigned.
             */
            virtual void Set(const Float* value) override;

            // override (RelativePropertySetter)
            /**
             *  Initialization of the RelativePropertySetter.
             */
            virtual void Initialize() override;

        private:
            Vector3 m_rotation;
        };

        /**
         * @brief A RelativePropertySetter that sets the rotation, X of a Node.
         *
         * The absolute rotation will be calculated from the initial value by adding the relative one.
         */
        class RotateXNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

        public:
            FEATSTD_RTTI_DECLARATION();

            FEATSTD_TYPEDEF_SHARED_POINTER(RotateXNodeRelativePropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Constructor
             */
            RotateXNodeRelativePropertySetter():m_rotationX(0.0F) {}

            /**
             *  Destructor
             */
            virtual ~RotateXNodeRelativePropertySetter() override {}

            // override (AnimationPropertySetter)
            /**
             *  A RelativePropertySetter that sets the rotation, X of a Node.
             *  @param  value   The relative value that is assigned.
             */
            virtual void Set(const Float* value) override;

            // override (RelativePropertySetter)
            /**
             *  Initialization of the RelativePropertySetter.
             */
            virtual void Initialize() override;

        private:
            Float m_rotationX;
        };

        /**
         * @brief A RelativePropertySetter that sets the rotation, Y of a Node.
         *
         * The absolute rotation will be calculated from the initial value by adding the relative one.
         */
        class RotateYNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

        public:
            FEATSTD_RTTI_DECLARATION();

            FEATSTD_TYPEDEF_SHARED_POINTER(RotateYNodeRelativePropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Constructor
             */
            RotateYNodeRelativePropertySetter():m_rotationY(0.0F) {}

            /**
             *  Destructor
             */
            virtual ~RotateYNodeRelativePropertySetter() override {}

            // override (AnimationPropertySetter)
            /**
             *  A RelativePropertySetter that sets the rotation, Y of a Node.
             *  @param  value   The relative value that is assigned.
             */
            virtual void Set(const Float* value) override;

            // override (RelativePropertySetter)
            /**
             *  Initialization of the RelativePropertySetter.
             */
            virtual void Initialize() override;

        private:
            Float m_rotationY;
        };

        /**
         * @brief A RelativePropertySetter that sets the rotation, Z of a Node.
         *
         * The absolute rotation will be calculated from the initial value by adding the relative one.
         */
        class RotateZNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

        public:
            FEATSTD_RTTI_DECLARATION();

            FEATSTD_TYPEDEF_SHARED_POINTER(RotateZNodeRelativePropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Constructor
             */
            RotateZNodeRelativePropertySetter():m_rotationZ(0.0F) {}

            /**
             *  Destructor
             */
            virtual ~RotateZNodeRelativePropertySetter() override {}

            // override (AnimationPropertySetter)
            /**
             *  A RelativePropertySetter that sets the rotation, Z of a Node.
             *  @param  value   The relative value that is assigned.
             */
            virtual void Set(const Float* value) override;

            // override (RelativePropertySetter)
            /**
             *  Initialization of the RelativePropertySetter.
             */
            virtual void Initialize() override;

        private:
            Float m_rotationZ;
        };

/** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
