//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RotateNodePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

namespace {
Vector3 RotationV3Getter(const Node& n)
{
    return n.GetRotation();
}

void RotationV3Setter(Node& n, const Vector3& v3)
{
    n.SetRotation(v3);
}
}
FEATSTD_RTTI_DEFINITION(RotateNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(RotateXNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(RotateYNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(RotateZNodePropertySetter, NodePropertySetter)

RotateNodePropertySetter::SharedPointer RotateNodePropertySetter::Create()
{
    return RotateNodePropertySetter::SharedPointer(CANDERA_NEW(RotateNodePropertySetter));
}

void RotateNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<RotationV3Getter, RotationV3Setter, XYZ_AxisSelector>(GetNode(), value);
}

RotateXNodePropertySetter::SharedPointer RotateXNodePropertySetter::Create()
{
    return RotateXNodePropertySetter::SharedPointer(CANDERA_NEW(RotateXNodePropertySetter));
}

void RotateXNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<RotationV3Getter, RotationV3Setter, X_AxisSelector>(GetNode(), value);
}

RotateYNodePropertySetter::SharedPointer RotateYNodePropertySetter::Create()
{
    return RotateYNodePropertySetter::SharedPointer(CANDERA_NEW(RotateYNodePropertySetter));
}

void RotateYNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<RotationV3Getter, RotationV3Setter, Y_AxisSelector>(GetNode(), value);
}

RotateZNodePropertySetter::SharedPointer RotateZNodePropertySetter::Create()
{
    return RotateZNodePropertySetter::SharedPointer(CANDERA_NEW(RotateZNodePropertySetter));
}

void RotateZNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<RotationV3Getter, RotationV3Setter, Z_AxisSelector>(GetNode(), value);
}

    }
}
