//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NodePropertySetter_H)
#define CANDERA_NodePropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

class Node;

namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

/** @brief A PropertySetter that sets properties of a Node. This is a base class.*/
class NodePropertySetter : public AnimationPropertySetter {

    FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

public:
    FEATSTD_TYPEDEF_SHARED_POINTER(NodePropertySetter);

    FEATSTD_RTTI_DECLARATION();

    /**
     *  Constructor
     */
    NodePropertySetter();

    /**
     *  Destructor
     */
    virtual ~NodePropertySetter() override;

    /**
     *  Assigns a node to the PropertySetter.
     *  @param node The node that is assigned.
     */
    void SetNode(Candera::Node* node) { m_node = node; }

    /**
     *  Retrieves the current node of the PorpertySetter.
     *  @return The current node.
     */
    Node* GetNode() { return m_node; }
    const Node* GetNode() const { return m_node; }

private:
    Node* m_node;

    CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::NodePropertySetter::NodePropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
    NodePropertySetter(const NodePropertySetter&);
    NodePropertySetter& operator=(const NodePropertySetter&);
};



/** @} */ // end of AnimationPropertySetters3D

}
}
#endif
