//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_MaterialSpecularPowerPropertySetter_H)
#define CANDERA_MaterialSpecularPowerPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/MaterialPropertySetter.h>

namespace Candera {

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */
 
        /** @brief A PropertySetter that sets the specular power of the Material of a Node. */
        class MaterialSpecularPowerPropertySetter : public MaterialPropertySetter {

            FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

        public:
            FEATSTD_RTTI_DECLARATION();

            FEATSTD_TYPEDEF_SHARED_POINTER(MaterialSpecularPowerPropertySetter);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            // override (AnimationPropertySetter)
            /**
             *  A PropertySetter that sets the specular power of the Material of a Node.
             *  @param value The value that is assigned.
             */
            virtual void Set(const Float* value) override;
        };
 
/** @} */ // end of AnimationPropertySetters3D
 
    }
}
#endif
