//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MaterialSpecularPowerPropertySetter.h"
#include <Candera/Engine3D/Core/Appearance.h>
#include <Candera/Engine3D/Core/Material.h>
#include <Candera/Engine3D/Core/Node.h>

namespace Candera {
    namespace Animation {

        FEATSTD_RTTI_DEFINITION(MaterialSpecularPowerPropertySetter, MaterialPropertySetter)

        MaterialSpecularPowerPropertySetter::SharedPointer MaterialSpecularPowerPropertySetter::Create()
        {
            return MaterialSpecularPowerPropertySetter::SharedPointer(CANDERA_NEW(MaterialSpecularPowerPropertySetter));
        }

        void MaterialSpecularPowerPropertySetter::Set(const Float* value)
        {
            if (value == 0) {
                return;
            }
            MemoryManagement::SharedPointer<Material> mat = GetMaterial();
            if (mat.PointsToNull()) {
                return;
            }

            mat->SetSpecularPower(value[0]);
        }
    }
}
