//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_MaterialPropertySetter_H)
#define CANDERA_MaterialPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Engine3D/Core/Material.h>

namespace Candera {
    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets properties of a Material. This is a base class.*/
        class MaterialPropertySetter : public AnimationPropertySetter {

                FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(MaterialPropertySetter);

                /**
                 *  Constructor
                 */
                MaterialPropertySetter(): m_material(0) {};

                /**
                 *  Destructor
                 */
                virtual ~MaterialPropertySetter() override {};

                /**
                 *  Assigns a material to the PropertySetter.
                 *  @param material The material that is assigned.
                 */
                void SetMaterial(const Candera::MemoryManagement::SharedPointer<Material>& material) {
                    m_material = material;
                }

                /**
                 *  Retrieves the current material of the PorpertySetter.
                 *  @return The current material.
                 */
                Candera::MemoryManagement::SharedPointer<Material> GetMaterial() const {
                    return m_material;
                }

            private:
                Candera::MemoryManagement::SharedPointer<Material> m_material;

                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::MaterialPropertySetter::MaterialPropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
                MaterialPropertySetter(const MaterialPropertySetter&);
                MaterialPropertySetter& operator=(const MaterialPropertySetter&);
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}

#endif //CANDERA_MaterialPropertySetter_H
