//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_IntUniformPropertySetter_H)
#define CANDERA_IntUniformPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/UniformPropertySetter.h>

namespace Candera {

namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */
 
/** @brief A PropertySetter that sets a Int (array) uniform of a ShaderParamSetter. */
class IntUniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(IntUniformPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets a Int (array) uniform of a ShaderParamSetter.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override { SetInt(value, 1); }
};

/** @brief A PropertySetter that sets a IntVec2 (array) uniform of a ShaderParamSetter. */
class IntVec2UniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(IntVec2UniformPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets a IntVec2 (array) uniform of a ShaderParamSetter.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override { SetInt(value, 2); }
};

/** @brief A PropertySetter that sets a IntVec3 (array) uniform of a ShaderParamSetter. */
class IntVec3UniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(IntVec3UniformPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets a IntVec3 (array) uniform of a ShaderParamSetter.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override { SetInt(value, 3); }
};

/** @brief A PropertySetter that sets a IntVec4 (array) uniform of a ShaderParamSetter. */
class IntVec4UniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(IntVec4UniformPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets a IntVec4 (array) uniform of a ShaderParamSetter.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override { SetInt(value, 4); }
};

/** @brief A PropertySetter that sets a Sampler2D (array) uniform of a ShaderParamSetter. */
class Sampler2DUniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(Sampler2DUniformPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets a Sampler2D (array) uniform of a ShaderParamSetter.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override { SetInt(value, 1); }
};

/** @brief A PropertySetter that sets a SamplerCube (array) uniform of a ShaderParamSetter. */
class SamplerCubeUniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(SamplerCubeUniformPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets a SamplerCube (array) uniform of a ShaderParamSetter.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override { SetInt(value, 1); }
};
 
/** @} */ // end of AnimationPropertySetters3D
 
}
}
#endif
