//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "IntUniformPropertySetter.h"

namespace Candera {
    namespace Animation {
        FEATSTD_RTTI_DEFINITION(IntUniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(IntVec2UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(IntVec3UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(IntVec4UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(Sampler2DUniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(SamplerCubeUniformPropertySetter, UniformPropertySetter)

        IntUniformPropertySetter::SharedPointer IntUniformPropertySetter::Create()
        {
            return IntUniformPropertySetter::SharedPointer(CANDERA_NEW(IntUniformPropertySetter));
        }

        IntVec2UniformPropertySetter::SharedPointer IntVec2UniformPropertySetter::Create()
        {
            return IntVec2UniformPropertySetter::SharedPointer(CANDERA_NEW(IntVec2UniformPropertySetter));
        }

        IntVec3UniformPropertySetter::SharedPointer IntVec3UniformPropertySetter::Create()
        {
            return IntVec3UniformPropertySetter::SharedPointer(CANDERA_NEW(IntVec3UniformPropertySetter));
        }

        IntVec4UniformPropertySetter::SharedPointer IntVec4UniformPropertySetter::Create()
        {
            return IntVec4UniformPropertySetter::SharedPointer(CANDERA_NEW(IntVec4UniformPropertySetter));
        }

        Sampler2DUniformPropertySetter::SharedPointer Sampler2DUniformPropertySetter::Create()
        {
            return Sampler2DUniformPropertySetter::SharedPointer(CANDERA_NEW(Sampler2DUniformPropertySetter));
        }

        SamplerCubeUniformPropertySetter::SharedPointer SamplerCubeUniformPropertySetter::Create()
        {
            return SamplerCubeUniformPropertySetter::SharedPointer(CANDERA_NEW(SamplerCubeUniformPropertySetter));
        }

    }
}
