//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GENERICLODCRITERIONVALUEPROPERTYSETTER_H)
#define CANDERA_GENERICLODCRITERIONVALUEPROPERTYSETTER_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

    class GenericValueLodCriterion;

    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets the value for a generic LodCriterion. */
        class GenericLodCriterionValuePropertySetter : public AnimationPropertySetter {

                FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

            public:
                FEATSTD_TYPEDEF_SHARED_POINTER(GenericLodCriterionValuePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                FEATSTD_RTTI_DECLARATION();

                GenericLodCriterionValuePropertySetter();

                /**
                 *  Sets the value for a generic LodCriterion.
                 *  @param genericValueLodCriterion The generic LodCriterion that is assigend.
                 */
                void SetGenericValueLodCriterion(GenericValueLodCriterion* genericValueLodCriterion);

                /**
                 *  Retrieves the value for a generic LodCriterion.
                 *  @return The current generic LodCriterion.
                 */
                const GenericValueLodCriterion* GetGenericValueLodCriterion() const;

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the value for a generic LodCriterion.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;

            private:
                GenericValueLodCriterion* m_genericValueLodCriterion;

                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::GenericLodCriterionValuePropertySetter::GenericLodCriterionValuePropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
                GenericLodCriterionValuePropertySetter(const GenericLodCriterionValuePropertySetter&);
                GenericLodCriterionValuePropertySetter& operator=(const GenericLodCriterionValuePropertySetter&);
        };

        /** @} */ // end of AnimationPropertySetters3D

    }

}
#endif
