//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericLodCriterionValuePropertySetter.h"
#include <Candera/Engine3D/Core/GenericValueLodCriterion.h>

namespace Candera {
    namespace Animation {

    FEATSTD_RTTI_DEFINITION(GenericLodCriterionValuePropertySetter, AnimationPropertySetter)

GenericLodCriterionValuePropertySetter::GenericLodCriterionValuePropertySetter() :
    Base(),
    m_genericValueLodCriterion(0)
{
}

GenericLodCriterionValuePropertySetter::SharedPointer GenericLodCriterionValuePropertySetter::Create()
{
    return GenericLodCriterionValuePropertySetter::SharedPointer(CANDERA_NEW(GenericLodCriterionValuePropertySetter));
}

void GenericLodCriterionValuePropertySetter::SetGenericValueLodCriterion(GenericValueLodCriterion* genericValueLodCriterion)
{
    m_genericValueLodCriterion = genericValueLodCriterion;
}

const GenericValueLodCriterion* GenericLodCriterionValuePropertySetter::GetGenericValueLodCriterion() const
{
    return m_genericValueLodCriterion;
}

void GenericLodCriterionValuePropertySetter::Set(const Float* value)
{
    if (value == 0) {
        return;
    }

    if (m_genericValueLodCriterion == 0) {
        return;
    }
    m_genericValueLodCriterion->SetCriterionValue(value[0]);
}
    }
}
