//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_FloatUniformPropertySetter_H)
#define CANDERA_FloatUniformPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/UniformPropertySetter.h>

namespace Candera {
    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets a Float (array) uniform of a ShaderParamSetter. */
        class FloatUniformPropertySetter : public UniformPropertySetter {

                FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatUniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a Float (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 1);
                }
        };

        /** @brief A PropertySetter that sets a FloatVec2 (array) uniform of a ShaderParamSetter. */
        class FloatVec2UniformPropertySetter : public UniformPropertySetter {

                FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatVec2UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a FloatVec2 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 2);
                }
        };

        /** @brief A PropertySetter that sets a FloatVec3 (array) uniform of a ShaderParamSetter. */
        class FloatVec3UniformPropertySetter : public UniformPropertySetter {

            FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatVec3UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a FloatVec3 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 3);
                }
        };

        /** @brief A PropertySetter that sets a FloatVec4 (array) uniform of a ShaderParamSetter. */
        class FloatVec4UniformPropertySetter : public UniformPropertySetter {

            FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatVec4UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a FloatVec4 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 4);
                }
        };

        /** @brief A PropertySetter that sets a FloatMat2 (array) uniform of a ShaderParamSetter. */
        class FloatMat2UniformPropertySetter : public UniformPropertySetter {

            FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatMat2UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a FloatMat2 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 4);
                }
        };

        /** @brief A PropertySetter that sets a FloatMat3 (array) uniform of a ShaderParamSetter. */
        class FloatMat3UniformPropertySetter : public UniformPropertySetter {

            FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatMat3UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a FloatMat3 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 9);
                }
        };

        /** @brief A PropertySetter that sets a FloatMat4 (array) uniform of a ShaderParamSetter. */
        class FloatMat4UniformPropertySetter : public UniformPropertySetter {

            FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(FloatMat4UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a FloatMat4 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override {
                    SetFloat(value, 16);
                }
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
