//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "FloatUniformPropertySetter.h"

namespace Candera {
    namespace Animation {
        FEATSTD_RTTI_DEFINITION(FloatUniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(FloatVec2UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(FloatVec3UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(FloatVec4UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(FloatMat2UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(FloatMat3UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(FloatMat4UniformPropertySetter, UniformPropertySetter)

        FloatUniformPropertySetter::SharedPointer FloatUniformPropertySetter::Create()
        {
            return FloatUniformPropertySetter::SharedPointer(CANDERA_NEW(FloatUniformPropertySetter));
        }

        FloatVec2UniformPropertySetter::SharedPointer FloatVec2UniformPropertySetter::Create()
        {
            return FloatVec2UniformPropertySetter::SharedPointer(CANDERA_NEW(FloatVec2UniformPropertySetter));
        }

        FloatVec3UniformPropertySetter::SharedPointer FloatVec3UniformPropertySetter::Create()
        {
            return FloatVec3UniformPropertySetter::SharedPointer(CANDERA_NEW(FloatVec3UniformPropertySetter));
        }

        FloatVec4UniformPropertySetter::SharedPointer FloatVec4UniformPropertySetter::Create()
        {
            return FloatVec4UniformPropertySetter::SharedPointer(CANDERA_NEW(FloatVec4UniformPropertySetter));
        }

        FloatMat2UniformPropertySetter::SharedPointer FloatMat2UniformPropertySetter::Create()
        {
            return FloatMat2UniformPropertySetter::SharedPointer(CANDERA_NEW(FloatMat2UniformPropertySetter));
        }

        FloatMat3UniformPropertySetter::SharedPointer FloatMat3UniformPropertySetter::Create()
        {
            return FloatMat3UniformPropertySetter::SharedPointer(CANDERA_NEW(FloatMat3UniformPropertySetter));
        }

        FloatMat4UniformPropertySetter::SharedPointer FloatMat4UniformPropertySetter::Create()
        {
            return FloatMat4UniformPropertySetter::SharedPointer(CANDERA_NEW(FloatMat4UniformPropertySetter));
        }

    }
}
