//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ColorLightPropertySetter_H)
#define CANDERA_ColorLightPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/LightPropertySetter.h>

namespace Candera {
    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets the ambient, RGB part of the Material of a Node. */
        class AmbientLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(AmbientLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the ambient, RGB part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the ambient, R part of the Material of a Node. */
        class AmbientRLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(AmbientRLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the ambient, R part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the ambient, G part of the Material of a Node. */
        class AmbientGLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(AmbientGLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the ambient, G part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the ambient, B part of the Material of a Node. */
        class AmbientBLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(AmbientBLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the ambient, B part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };


        /** @brief A PropertySetter that sets the Diffuse, RGB part of the Material of a Node. */
        class DiffuseLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(DiffuseLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Diffuse, RGB part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the Diffuse, R part of the Material of a Node. */
        class DiffuseRLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(DiffuseRLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Diffuse, R part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the Diffuse, G part of the Material of a Node. */
        class DiffuseGLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(DiffuseGLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Diffuse, G part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the Diffuse, B part of the Material of a Node. */
        class DiffuseBLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(DiffuseBLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Diffuse, B part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };


        /** @brief A PropertySetter that sets the Specular, RGB part of the Material of a Node. */
        class SpecularLightPropertySetter : public LightPropertySetter {

                FEATSTD_TYPEDEF_BASE(LightPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(SpecularLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Specular, RGB part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the Specular, R part of the Material of a Node. */
        class SpecularRLightPropertySetter : public LightPropertySetter {

                typedef LightPropertySetter Base;

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(SpecularRLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Specular, R part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the Specular, G part of the Material of a Node. */
        class SpecularGLightPropertySetter : public LightPropertySetter {

                typedef LightPropertySetter Base;

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(SpecularGLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Specular, G part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the Specular, B part of the Material of a Node. */
        class SpecularBLightPropertySetter : public LightPropertySetter {

                typedef LightPropertySetter Base;

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(SpecularBLightPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the Specular, B part of the Material of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
