//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ColorLightPropertySetter.h"
#include <Candera/Engine3D/Core/Light.h>
#include <Candera/Engine3D/AnimationPropertySetters/ColorPropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

        namespace {
            Color GetAmbient(const Light& light)
            {
                return light.GetAmbient();
            }

            void SetAmbient(Light& light, const Color& col)
            {
                light.SetAmbient(col);
            }

            Color GetDiffuse(const Light& light)
            {
                return light.GetDiffuse();
            }

            void SetDiffuse(Light& light, const Color& col)
            {
                light.SetDiffuse(col);
            }

            Color GetSpecular(const Light& light)
            {
                return light.GetSpecular();
            }

            void SetSpecular(Light& light, const Color& col)
            {
                light.SetSpecular(col);
            }
        }

        FEATSTD_RTTI_DEFINITION(AmbientLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(AmbientRLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(AmbientGLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(AmbientBLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(DiffuseLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(DiffuseRLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(DiffuseGLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(DiffuseBLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(SpecularLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(SpecularRLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(SpecularGLightPropertySetter, LightPropertySetter)
        FEATSTD_RTTI_DEFINITION(SpecularBLightPropertySetter, LightPropertySetter)

        AmbientLightPropertySetter::SharedPointer AmbientLightPropertySetter::Create()
        {
            return AmbientLightPropertySetter::SharedPointer(CANDERA_NEW(AmbientLightPropertySetter));
        }

        void AmbientLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetAmbient, SetAmbient, RGB_ColorComponentSelector>(GetLight(), value);
        }

        AmbientRLightPropertySetter::SharedPointer AmbientRLightPropertySetter::Create()
        {
            return AmbientRLightPropertySetter::SharedPointer(CANDERA_NEW(AmbientRLightPropertySetter));
        }

        void AmbientRLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetAmbient, SetAmbient, R_ColorComponentSelector>(GetLight(), value);
        }

        AmbientGLightPropertySetter::SharedPointer AmbientGLightPropertySetter::Create()
        {
            return AmbientGLightPropertySetter::SharedPointer(CANDERA_NEW(AmbientGLightPropertySetter));
        }

        void AmbientGLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetAmbient, SetAmbient, G_ColorComponentSelector>(GetLight(), value);
        }

        AmbientBLightPropertySetter::SharedPointer AmbientBLightPropertySetter::Create()
        {
            return AmbientBLightPropertySetter::SharedPointer(CANDERA_NEW(AmbientBLightPropertySetter));
        }

        void AmbientBLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetAmbient, SetAmbient, B_ColorComponentSelector>(GetLight(), value);
        }

        DiffuseLightPropertySetter::SharedPointer DiffuseLightPropertySetter::Create()
        {
            return DiffuseLightPropertySetter::SharedPointer(CANDERA_NEW(DiffuseLightPropertySetter));
        }

        void DiffuseLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetDiffuse, SetDiffuse, RGB_ColorComponentSelector>(GetLight(), value);
        }

        DiffuseRLightPropertySetter::SharedPointer DiffuseRLightPropertySetter::Create()
        {
            return DiffuseRLightPropertySetter::SharedPointer(CANDERA_NEW(DiffuseRLightPropertySetter));
        }

        void DiffuseRLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetDiffuse, SetDiffuse, R_ColorComponentSelector>(GetLight(), value);
        }

        DiffuseGLightPropertySetter::SharedPointer DiffuseGLightPropertySetter::Create()
        {
            return DiffuseGLightPropertySetter::SharedPointer(CANDERA_NEW(DiffuseGLightPropertySetter));
        }

        void DiffuseGLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetDiffuse, SetDiffuse, G_ColorComponentSelector>(GetLight(), value);
        }

        DiffuseBLightPropertySetter::SharedPointer DiffuseBLightPropertySetter::Create()
        {
            return DiffuseBLightPropertySetter::SharedPointer(CANDERA_NEW(DiffuseBLightPropertySetter));
        }

        void DiffuseBLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetDiffuse, SetDiffuse, B_ColorComponentSelector>(GetLight(), value);
        }


        SpecularLightPropertySetter::SharedPointer SpecularLightPropertySetter::Create()
        {
            return SpecularLightPropertySetter::SharedPointer(CANDERA_NEW(SpecularLightPropertySetter));
        }

        void SpecularLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetSpecular, SetSpecular, RGB_ColorComponentSelector>(GetLight(), value);
        }

        SpecularRLightPropertySetter::SharedPointer SpecularRLightPropertySetter::Create()
        {
            return SpecularRLightPropertySetter::SharedPointer(CANDERA_NEW(SpecularRLightPropertySetter));
        }

        void SpecularRLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetSpecular, SetSpecular, R_ColorComponentSelector>(GetLight(), value);
        }

        SpecularGLightPropertySetter::SharedPointer SpecularGLightPropertySetter::Create()
        {
            return SpecularGLightPropertySetter::SharedPointer(CANDERA_NEW(SpecularGLightPropertySetter));
        }

        void SpecularGLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetSpecular, SetSpecular, G_ColorComponentSelector>(GetLight(), value);
        }

        SpecularBLightPropertySetter::SharedPointer SpecularBLightPropertySetter::Create()
        {
            return SpecularBLightPropertySetter::SharedPointer(CANDERA_NEW(SpecularBLightPropertySetter));
        }

        void SpecularBLightPropertySetter::Set(const Float* value)
        {
            SetLightColorProperty<GetSpecular, SetSpecular, B_ColorComponentSelector>(GetLight(), value);
        }
    }
}
