//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CameraViewportPropertySetter_H)
#define CANDERA_CameraViewportPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/BaseCameraPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "Viewport" property of a Camera.
     */
    class CameraViewportPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraViewportPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "Viewport" property of the Camera object.
         *
         * @param value - pointer to an array of 4 float values for the Viewport rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraViewportPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Left value for the "Viewport" property of a Camera.
    */
    class CameraViewportLeftPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraViewportLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Left value for the "Viewport" property of a Camera.
        *
        * @param value - Left value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraViewportLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Top value for the "Viewport" property of a Camera.
    */
    class CameraViewportTopPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraViewportTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Top value for the "Viewport" property of the Camera object.
        *
        * @param value - Top value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraViewportTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Width value for the "Viewport" property of a Camera.
    */
    class CameraViewportWidthPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraViewportWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets Width value for the "Viewport" property of the Camera object.
        *
        * @param value - Width value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraViewportWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Height value for the "Viewport" property of a Camera.
    */
    class CameraViewportHeightPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraViewportHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Height value for the "Viewport" property of the Camera object.
        *
        * @param value - Height value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraViewportHeightPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_CameraViewportPropertySetter_H
