//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CameraViewportPropertySetter.h"
#include <Candera/Engine3D/Core/Camera.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(CameraViewportPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraViewportLeftPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraViewportTopPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraViewportWidthPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraViewportHeightPropertySetter, BaseCameraPropertySetter)


    /******************************************************************************
    *  CameraViewportPropertySetter method definitions
    ******************************************************************************/
    void CameraViewportPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        camera->SetViewport(Rectangle(value[0], value[1], value[2], value[3]));
    }
    
    CameraViewportPropertySetter::SharedPointer CameraViewportPropertySetter::Create()
    {
        return CameraViewportPropertySetter::SharedPointer(CANDERA_NEW(CameraViewportPropertySetter));
    }

    /******************************************************************************
    *  CameraViewportLeftPropertySetter method definitions
    ******************************************************************************/
    void CameraViewportLeftPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetLeft(*value);
        camera->SetViewport(rect);
    }

    CameraViewportLeftPropertySetter::SharedPointer CameraViewportLeftPropertySetter::Create()
    {
        return CameraViewportLeftPropertySetter::SharedPointer(CANDERA_NEW(CameraViewportLeftPropertySetter));
    }

    /******************************************************************************
    *  CameraViewportTopPropertySetter method definitions
    ******************************************************************************/
    void CameraViewportTopPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetTop(*value);
        camera->SetViewport(rect);
    }

    CameraViewportTopPropertySetter::SharedPointer CameraViewportTopPropertySetter::Create()
    {
        return CameraViewportTopPropertySetter::SharedPointer(CANDERA_NEW(CameraViewportTopPropertySetter));
    }

    /******************************************************************************
    *  CameraViewportWidthPropertySetter method definitions
    ******************************************************************************/
    void CameraViewportWidthPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetWidth(*value);
        camera->SetViewport(rect);
    }

    CameraViewportWidthPropertySetter::SharedPointer CameraViewportWidthPropertySetter::Create()
    {
        return CameraViewportWidthPropertySetter::SharedPointer(CANDERA_NEW(CameraViewportWidthPropertySetter));
    }

    /******************************************************************************
    *  CameraViewportHeightPropertySetter method definitions
    ******************************************************************************/
    void CameraViewportHeightPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetHeight(*value);
        camera->SetViewport(rect);
    }

    CameraViewportHeightPropertySetter::SharedPointer CameraViewportHeightPropertySetter::Create()
    {
        return CameraViewportHeightPropertySetter::SharedPointer(CANDERA_NEW(CameraViewportHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
