//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CameraFovPropertySetter_H)
#define CANDERA_CameraFovPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

    class Camera;

    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets FOV (field of view) of a Camera. */
        class CameraFovPropertySetter : public AnimationPropertySetter {

                FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

            public:
                FEATSTD_TYPEDEF_SHARED_POINTER(CameraFovPropertySetter);

                /**
                 *  Constructor
                 */
                CameraFovPropertySetter();

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                FEATSTD_RTTI_DECLARATION();

                /**
                 *  Assigns a camera to the PropertySetter
                 *  @param camera The camera that is assigned.
                 */
                void SetCamera(Camera* camera);

                /**
                 *  Retrieves a pointer to the current camera.
                 *  @return A pointer to the current camera.
                 */
                const Camera* GetCamera() const;

                /**
                 *  Sets the value.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;

            private:
                Camera* m_camera;

                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::CameraFovPropertySetter::CameraFovPropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
                CameraFovPropertySetter(const CameraFovPropertySetter&);
                CameraFovPropertySetter& operator=(const CameraFovPropertySetter&);
        };

        /** @} */ // end of AnimationPropertySetters3D

    }

}
#endif
