//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CameraFovPropertySetter.h"
#include <Candera/Engine3D/Core/Camera.h>
#include <Candera/Engine3D/Core/PerspectiveProjection.h>

namespace Candera {
    namespace Animation {

    FEATSTD_RTTI_DEFINITION(CameraFovPropertySetter, AnimationPropertySetter)

CameraFovPropertySetter::CameraFovPropertySetter() :
    Base(),
    m_camera(0)
{
}

CameraFovPropertySetter::SharedPointer CameraFovPropertySetter::Create()
{
    return CameraFovPropertySetter::SharedPointer(CANDERA_NEW(CameraFovPropertySetter));
}

void CameraFovPropertySetter::SetCamera(Camera* camera)
{
    m_camera = camera;
}

const Camera* CameraFovPropertySetter::GetCamera() const
{
    return m_camera;
}

void CameraFovPropertySetter::Set(const Float* value)
{
    if (value == 0) {
        return;
    }

    Camera* const cam = m_camera;
    if (cam == 0) {
        return;
    }

    MemoryManagement::SharedPointer<Projection> proj = cam->GetProjection();
    if (proj.PointsToNull()) {
        return;
    }

    if (!proj->IsTypeOf(PerspectiveProjection::GetTypeId())) {
        return;
    }

    CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1774, type check above ensures cast is safe)
    PerspectiveProjection* perspProj = static_cast<PerspectiveProjection*>(proj.GetPointerToSharedInstance());
    perspProj->SetFovYDegrees(value[0]);
}
    }
}
