//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BoolUniformPropertySetter_H)
#define CANDERA_BoolUniformPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/UniformPropertySetter.h>

namespace Candera {
    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets a boolean (array) uniform of a ShaderParamSetter. */
        class BoolUniformPropertySetter : public UniformPropertySetter {

                FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(BoolUniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a boolean (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned and converted into bool. value < 0.5 = 0, otherwise 1
                 */
                virtual void Set(const Float* value) override{
                    SetBool(value, 1);
                }
        };

        /** @brief A PropertySetter that sets a BoolVec2 (array) uniform of a ShaderParamSetter. */
        class BoolVec2UniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(BoolVec2UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a BoolVec2 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned and converted into bool. value < 0.5 = 0, otherwise 1
                 */
                virtual void Set(const Float* value) override{
                    SetBool(value, 2);
                }
        };

        /** @brief A PropertySetter that sets a BoolVec3 (array) uniform of a ShaderParamSetter. */
        class BoolVec3UniformPropertySetter : public UniformPropertySetter {

            FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(BoolVec3UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a BoolVec3 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned and converted into bool. value < 0.5 = 0, otherwise 1
                 */
                virtual void Set(const Float* value) override{
                    SetBool(value, 3);
                }
        };

        /** @brief A PropertySetter that sets a BoolVec4 (array) uniform of a ShaderParamSetter. */
        class BoolVec4UniformPropertySetter : public UniformPropertySetter {

    FEATSTD_TYPEDEF_BASE(UniformPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(BoolVec4UniformPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets a BoolVec4 (array) uniform of a ShaderParamSetter.
                 *  @param value The value that is assigned and converted into bool. value < 0.5 = 0, otherwise 1
                 */
                virtual void Set(const Float* value) override{
                    SetBool(value, 4);
                }
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
