//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseCameraPropertySetter_H)
#define CANDERA_BaseCameraPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera {

    class Camera;

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

    /**
     *  @brief Base class for Camera property setters.
     */
        class BaseCameraPropertySetter : public AnimationPropertySetter {
            FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(BaseCameraPropertySetter);

            FEATSTD_RTTI_DECLARATION();

            /**
            * Constructor.
            */
            BaseCameraPropertySetter();

            /**
            * Sets the Camera the property setter operates on.
            * @param node The Camera object.
            */
            void SetCamera(Candera::Camera* node) { m_camera = node; }

            /**
            * Gets the Camera the property setter operates on.
            * @return The Camera object.
            */
            Candera::Camera* GetCamera() { return m_camera; }

            const Candera::Camera* GetCamera() const { return m_camera; }

        private:
            Candera::Camera* m_camera;
        };

        /** @} */ // end of AnimationPropertySetters2D
    }// namespace Animation

}// namespace Candera

#endif  // CANDERA_BaseCameraPropertySetter_H
