//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AlphaNodePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>

namespace Candera {
    namespace Animation {

        FEATSTD_RTTI_DEFINITION(AlphaNodePropertySetter, NodePropertySetter)

AlphaNodePropertySetter::SharedPointer AlphaNodePropertySetter::Create()
{
    return AlphaNodePropertySetter::SharedPointer(CANDERA_NEW(AlphaNodePropertySetter));
}

void AlphaNodePropertySetter::Set(const Float* value)
{
    if (value == 0) {
        return;
    }

    Node* const n = GetNode();
    if (n == 0) {
        return;
    }

    n->SetAlphaValue(value[0]);
}
    }
}
