//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_InPlaceEffect2D_H)
    #define CANDERA_InPlaceEffect2D_H

#include <Candera/Engine2D/Effects/Effect2D.h>

namespace Candera {

/** @addtogroup Effects2D
 *  @{
 */

    /**
     *  @brief Base class for all 2D in-place effects.
     */
    class InPlaceEffect2D : public Effect2D {

        FEATSTD_TYPEDEF_BASE(Effect2D);

        public:
            /**
             *  Gets a valid InPlaceEffect2D pointer if the effect is an in-place effect or
             *  if it is a combined effect and has an in-place effect, otherwise 0.
             *  @param      index   Out parameter to retrieve the number of in-place effects in case a
             *                      combined effect implements more than one in-place effects.
             *                      The count is set to 1.
             *
             *  @return             A valid InPlaceEffect2D pointer if the effect is an in-place effect or
             *                      if it is a combined effect and has an in-place effect, otherwise 0.
             */
            virtual InPlaceEffect2D* GetInPlaceEffect2D(UInt8 index) override { return (index == 0) ? this : 0; }

            /**
             *  Should be overridden if a combined effect implements more than one in-place effect.
             *  @return     The count of in-place effects within a combined effect.
             */
            virtual UInt8 GetInPlaceEffect2DCount() const override { return 1; }

            FEATSTD_RTTI_DECLARATION();
    };

 /** @} */ // end of Effects2D

}   // namespace Candera

#endif  // CANDERA_InPlaceEffect2D_H
