//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CombinedEffect2D_H)
    #define CANDERA_CombinedEffect2D_H

#include <Candera/Engine2D/Effects/Effect2D.h>

namespace Candera {

/** @addtogroup Effects2D
 *  @{
 */

    /**
     *  @brief Base class for all 2D combined effects.
     */
    class CombinedEffect2D : public Effect2D {

        FEATSTD_TYPEDEF_BASE(Effect2D);

        public:
            FEATSTD_RTTI_DECLARATION();

            // overrides Effect2D::GetBoundingRectangle
            virtual void GetBoundingRectangle(Rectangle& boundingRectangle) const override;

            // overrides Effect2D::GetBasePoint
            virtual void GetBasePoint(Vector2& basePoint) const override;

            // overrides Effect2D::GetLayoutingRectangle
            virtual void GetLayoutingRectangle(Rectangle& rectangle) const override;
    };

 /** @} */ // end of Effects2D

}   // namespace Candera

#endif  // CANDERA_CombinedEffect2D_H
