//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CombinedEffect2D.h"
#include <Candera/Engine2D/Effects/BrushEffect2D.h>

namespace Candera {

    FEATSTD_RTTI_DEFINITION(CombinedEffect2D, Effect2D)

    /******************************************************************************
    *  GetBoundingRectangle
    ******************************************************************************/
    void CombinedEffect2D::GetBoundingRectangle(Rectangle& boundingRectangle) const
    {
        BrushEffect2D* brushEffect = const_cast<CombinedEffect2D*>(this)->GetBrushEffect2D();
        if (brushEffect != 0) {
            brushEffect->GetBoundingRectangle(boundingRectangle);
        }
    }

    /******************************************************************************
    *  GetBoundingRectangle
    ******************************************************************************/
    void CombinedEffect2D::GetBasePoint(Vector2& basePoint) const
    {
        BrushEffect2D* brushEffect = const_cast<CombinedEffect2D*>(this)->GetBrushEffect2D();
        if (brushEffect != 0) {
            brushEffect->GetBasePoint(basePoint);
        }
    }


    /******************************************************************************
    *  GetLayoutingRectangle
    ******************************************************************************/
    void CombinedEffect2D::GetLayoutingRectangle(Rectangle& rectangle) const
    {
        BrushEffect2D* brushEffect = const_cast<CombinedEffect2D*>(this)->GetBrushEffect2D();
        if (brushEffect != 0) {
            brushEffect->GetLayoutingRectangle(rectangle);
        }
    }

}   // namespace Candera
