//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BrushEffect2D_H)
    #define CANDERA_BrushEffect2D_H

#include <Candera/Engine2D/Effects/Effect2D.h>
#include <Candera/Engine2D/Property/FilterProperty.h>
#include <CanderaPlatform/Device/Common/Effects/EffectDataTypes.h>

namespace Candera {

/** @addtogroup Effects2D
 *  @{
 */

    class Layouter;

    /**
     *  @brief Base class for all 2D brush effects.
     */
    class BrushEffect2D : public Effect2D {
        FEATSTD_TYPEDEF_BASE(Effect2D);

        public:
            /**
             *  Constructor
             */
            BrushEffect2D() : m_filter(RenderDevice2D::BilinearFilter) {}
            
            // overrides Effect2D::GetBrushEffect2D
            virtual BrushEffect2D* GetBrushEffect2D() override { return this; }

            // overrides Effect2D::GetLayoutingRectangle
            virtual void GetLayoutingRectangle(Rectangle& rectangle) const override;

            // overrides Effect2D::GetBasePoint
            virtual void GetBasePoint(Vector2& basePoint) const override;

            /**
             *  Retrieves the filter properties of this filter.
             *  @return The filter properties of this filter.
             */
            FilterProperty& Filter() { return m_filter; }
            /**
             *  Retrieves the filter properties of this filter.
             *  @return The filter properties of this filter.
             */
            const FilterProperty& Filter() const { return m_filter; }

            /// @cond Doxygen ignore - start

            FEATSTD_RTTI_DECLARATION();

            CdaEffect2DAbstractDef(Candera::BrushEffect2D, BrushEffect2D)
                CdaEffect2DProperties()

                    CdaEffect2DProperty(Filter, RenderDevice2D::Filter, m_filter)
                        CdaDescription("Filtering mode used with this brush.")
                        CdaUpdateType(ContinuousUpdateType)
                    CdaEffect2DPropertyEnd()

                CdaEffect2DPropertiesEnd()
            CdaEffect2DDefEnd()

            /// @endcond Doxygen ignore - end
        
        protected:
            FilterProperty m_filter;

            // Explicit protected Copy-Constructor, use Create() to create an instance of all derived classes.
            explicit BrushEffect2D(const BrushEffect2D& rhs);
            BrushEffect2D& operator = (const BrushEffect2D& rhs);
    };

 /** @} */ // end of Effects2D
 
}   // namespace Candera

#endif  // CANDERA_BrushEffect2D_H
