//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BrushEffect2D.h"

namespace Candera {

    FEATSTD_RTTI_DEFINITION(BrushEffect2D, Effect2D)


    void BrushEffect2D::GetLayoutingRectangle(Rectangle& rectangle) const
    {
        GetBoundingRectangle(rectangle);
    }

    /******************************************************************************
     *  GetBasePoint
     ******************************************************************************/
    void BrushEffect2D::GetBasePoint(Vector2& basePoint) const
    {
        Rectangle bound;
        GetLayoutingRectangle(bound);
        basePoint = bound.GetPosition() + (bound.GetSize() * 0.5F);
    }

    /******************************************************************************
     *  Copy constructor
     ******************************************************************************/
    BrushEffect2D::BrushEffect2D(const BrushEffect2D& rhs) :
        Base(rhs),
        m_filter(rhs.m_filter.Get())
    {
    }

}   // namespace Candera
