//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TextNodeRendererTools.h"
#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Diagnostics/Log.h>
#include <Candera/Engine2D/Core/TextNode2D.h>
#include <Candera/TextEngine/TextRenderer.h>
#include <Candera/TextEngine/ShapingOptions.h>
#include <Candera/TextEngine/LayoutingOptions.h>
#include <Candera/TextEngine/TextProperties.h>

namespace Candera {

    using namespace TextRendering;

    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaPlatformDevice);

    namespace Internal {

        void TextNodeRendererTools::RenderImage(Image2D& image,
            TextNode2D& textNode,
            RenderTarget2D* renderTarget,
            const Matrix3x2& localTransform,
            const Vector2& offset)
        {
            Matrix3x2 correctedTransform(localTransform);
            correctedTransform.Translate(offset.GetX(), offset.GetY());
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1058, Candera::Matrix3x2::Translate, "False positive because member Translate is called from Candera::TextNode2D instead.")
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(64, Candera::Matrix3x2 = Candera::TextNode2D, "False positive because here Candera::Matrix3x2 is not mentioned in the relevant call.")
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(64, float = struct, "False positive because here there is no interaction between such types.")
                textNode.Translate(offset);
            textNode.RenderImage(image, renderTarget, correctedTransform);
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1058, Candera::Matrix3x2::Translate, "False positive because member translate is called from Candera::TextNode2D instead.")
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(64, Candera::Matrix3x2 = Candera::TextNode2D, "False positive because here Candera::Matrix3x2 is not mentioned in the relevant call.")
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(64, float = struct, "False positive because here there is no interaction between such types.")
                textNode.Translate(-offset);
        }

        bool TextNodeRendererTools::RenderText(TextRenderContext& context,
            const TextNode2D& textNode,
            const TextCoordinate &offset)
        {
            return TextRenderer().Render(context,
                LayoutingOptions(offset), //text is already preprocessed, only offset is relevant
                ShapingOptions(textNode.GetStyle()),
                TextProperties(textNode.GetTextIterator()));

        }

    }


}   // namespace Candera
