//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SURFACE_TEXT_NODE_CACHE_H)
#define CANDERA_SURFACE_TEXT_NODE_CACHE_H

#include <Candera/Engine2D/Core/TextNodeRenderer/TextNodeRenderer.h>
#include <Candera/Engine2D/Core/ProxyImage2D.h>

namespace Candera {

    class GraphicDeviceUnit;

    /**
     *  @brief  This class represents a whole text cache. The text is drawn to
     *          a native surface, using the native API.
     *          @see Candera::TextNodeRenderer
     */
    class SurfaceTextNodeRenderer : public TextNodeRenderer
    {
        FEATSTD_TYPEDEF_BASE(Candera::TextNodeRenderer);
    public:        
        explicit SurfaceTextNodeRenderer(bool enableGlyphCaching);

        /**
        *  Constructor
        */
        CANDERA_DEPRECATED_3_3_0(
            "Please use Create() method to instantiate SurfaceTextNodeRenderer",
            SurfaceTextNodeRenderer());

        CANDERA_LINT_DECLARE_CLEANUP_FUNCTION(Candera::Internal::SurfaceTextNodeRenderer::Finalize)

#ifdef CANDERA_DEPRECATED_3_3_0
            /**
            * Destructor
            */
        virtual ~SurfaceTextNodeRenderer();
#else
#error  Make destructor protected.
#endif

        // overrides TextNodeRenderer::Clone
        virtual SurfaceTextNodeRenderer* Clone() const override;

        /**
        *  Creates an instance of this class.
        *  Use Dispose() to delete the instance.
        *  @return A pointer to the created object.
        */
        static SurfaceTextNodeRenderer* Create();

        // overrides TextNodeRenderer::Dispose
        virtual void Dispose() override;

        // overrides TextNodeRenderer::UnloadSelf
        virtual bool UnloadSelf() override;

        // overrides TextNodeRenderer::IsTextValidAfterUnload
        virtual bool IsTextValidAfterUnload() override { return false; }

        FEATSTD_RTTI_DECLARATION();

    private:
        bool m_mustBeDisposed;
        GraphicDeviceUnit* m_gdu;
        MemoryManagement::SharedPointer<ProxyImage2D> m_proxyImage;

        /**
        *  Copy Constructor
        *  sets m_mustBeDisposed to true
        */
        explicit SurfaceTextNodeRenderer(
            const SurfaceTextNodeRenderer& surfaceTextNodeRenderer);

        /**
        *  User defined constructor - to be called by Create()
        *  Sets m_mustBeDisposed to true
        */
        explicit SurfaceTextNodeRenderer(const Int& dummyInt);

        // overrides TextNodeRenderer::GetMeasureReferenceContext
        virtual const TextRendering::TextRenderContext* GetMeasureReferenceContext() const { return 0; }

        // overrides TextNodeRenderer::PreRender
        virtual bool PreRenderInternal(const TextNode2D& textNode);

        // overrides TextNodeRenderer::Render
        virtual void RenderInternal(TextNode2D& textNode, RenderTarget2D* renderTarget, const Matrix3x2& localTransform);

        void Finalize();
    };
}   // namespace Candera

#endif  // CANDERA_SURFACE_TEXT_NODE_CACHE_H
